//
//  AHKProgressWindowController.m
//  AH-K3001V Address Utility
//
//  Modified by FUJIDANA on Thu Apr 14 2005.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
//  ProgressController.m
//  BookmarkUtility
//
//  Created by raktajino on Sat Jun 26 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKProgressWindowController.h"
#import "AHKProgressing.h"

@implementation AHKProgressWindowController

// weak reference (not retain) to parent window
+ (id)sharedWindowControllerWithParentWindow:(NSWindow *)window
{
	static AHKProgressWindowController *sharedWindowController;
	
	if (!sharedWindowController) {
		sharedWindowController = [[AHKProgressWindowController alloc] initWithParentWindow:window];
	}
	return sharedWindowController;
}

// weak reference (not retain) to parent window
- (id)initWithParentWindow:(NSWindow *)window
{
	self = [super initWithWindowNibName:@"AHKProgressWindow"];
	if (self) {
		session				= NULL;
		isRequestedToAbort	= NO;
//		isExceptionRaised	= NO;
		parentWindow		= window;
	}
	return self;
}

- (void)dealloc
{
	if (session) {
		[self endProgress];
	}
	[super dealloc];
}

#pragma mark actions

- (IBAction)requestToAbortProgress:(id)sender
{
	isRequestedToAbort = YES;
}

#pragma mark methods supporting AHKProgressing

- (void)beginProgressWithMessage:(NSString *)message
{
	isRequestedToAbort = NO;
//	isExceptionRaised = NO;
	
	[self window]; // if the nib file has not yet loaded, load the nib file.
	
	if(message == nil) {
		[messageTextField setStringValue:NSLocalizedString(@"Communicating...", nil)];
	} else {
		[messageTextField setStringValue:message];
	}
	
	[countTextField setHidden:YES];
	
	[progressIndicator setIndeterminate:YES];
	[progressIndicator setUsesThreadedAnimation:YES];
	[progressIndicator startAnimation:self];
	
	[NSApp beginSheet:[self window]
	   modalForWindow:parentWindow
		modalDelegate:self
	   didEndSelector:NULL
		  contextInfo:NULL];
	
	session = [NSApp beginModalSessionForWindow:[self window]];
	[NSApp runModalSession:session];
}

- (void)startDeterminateProgressWithMaxValue:(double)maxValue message:(NSString *)message
{
	[progressIndicator setDoubleValue:0.0];
	[progressIndicator setMaxValue:maxValue];
	[progressIndicator setIndeterminate:NO];
	
	[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	[countTextField setHidden:NO];
	
	if (message) {
		[messageTextField setStringValue:message];
	}
	
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- refresh the progress window --
//- (void)updateProgressDoubleValue:(double)value
- (void)updateDoubleValue:(double)value message:(NSString *)message
{
	if (value > 0) {
		[progressIndicator setDoubleValue:value];
		[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	}
	if (message) {
		[messageTextField setStringValue:message];
	}
	
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- refresh the progress window --
- (void)incrementProgressBarBy:(double)value
{
	[progressIndicator incrementBy:value];
	[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- return YES when user request to abort --
- (BOOL)isRequestedToAbort
{
	return isRequestedToAbort;
}


// --- close the progress window --
- (void)endProgress
{
	if (session) {
//		[self updateDoubleValue:[progressIndicator maxValue] message:nil];
		[[self window] displayIfNeeded];
		[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.2]];
		// Wait a while so that the progress indicator finishes filling the bar.
		// There might exist the better way to refreshing the window
		
		[progressIndicator stopAnimation:self];
//		if(isExceptionRaised == NO) {
			// As written in the description of "beginModalSessionForWindow:" of
			// http://developer.apple.com/documentation/Cocoa/Reference/ApplicationKit/ObjC_classic/Classes/NSApplication.html
			//
			// If an exception is raised, beginModalSessionForWindow: arranges for proper cleanup. 
			// Do not use NS_DURING constructs to send an endModalSession: message in the event of 
			// an exception.
			[NSApp endModalSession:session];
//		}
		[NSApp endSheet:[self window]];
		[[self window] orderOut:self];
		
		session = NULL;
		isRequestedToAbort = NO;
		
		[NSApp requestUserAttention:NSInformationalRequest];
	}
//	isExceptionRaised = NO;
}

//- (void)notifyException:(NSException *)exception
//{
//	isExceptionRaised = YES;
//}

@end
